function xprime=statetrackingm_derivatives(t,x)

global k1 k icon xs xsr tstart grad dt CovnT ts tsr Xg Yg Zg hk N Zreal Zmin sk xsucc flag;  
global usave tsave 

x1=x(1);
x2=x(2);

dt=t-tstart;

if t==0  
   error=0; dt=CovnT;  
   % initilize the start grid site
   [Xg, Yg]=meshgrid([x1-0.1,x1,x1+0.1], [x2-0.1,x2,x2+0.1]);
   Xg=Xg(:);
   Yg=Yg(:);
   if icon==1 
      Zg=100*(Yg-Xg.^2).^2+(1-Xg).^2;  
   else
      Zg=5*Xg.^2+Yg.^2+4*Xg.*Yg-14.*Xg-6.*Yg+20;
   end
else
   error=norm(x-xs);
   % update model
   Xg(end+1)=x1;
   Yg(end+1)=x2;
   if icon==1 
      Zg(end+1)=100*(x2-x1.^2).^2+(1-x1).^2;  
   else
      Zg(end+1)=5*x1.^2+x2.^2+4*x1.*x2-14.*x1-6.*x2+20;
   end   
end

% the threshold is determined from the robust analysis
if icon==1
   thresh=norm(grad)/1000
else
   thresh=norm(grad)/10
end

%------------------------
% Trust Region Algorithm 
%------------------------

if (dt>=CovnT & error <=thresh)  
    % continue if the state is within the required neighberhood
    % banana function
if icon==1 
    xk=[x1;x2];
    if t>0 & flag==0  
       % compute the performance ratio
       rk=(Zreal-banana(xk))/(Zreal-Zmin)
      % pause
       if rk<0.25
           hk=max(hk/2);%,0.125); %norm(sk,2)/4;
       elseif  rk>0.75 %& norm(sk,2)==hk
           hk=2*hk;        
       else
           hk=hk;
       end        
       % check if this is a successful step
       if rk>0.01
           flag=1;  % successful
           xsucc(:,end+1)=xk;
       else  
           flag=0;  % not successful, need to go back
       end
    end
    
   if t==0 | flag==1       
      % perform function and gradient measurment
      [Zreal,grad]=banana(xk);         
      % obtain the data site within the trust region
      k=1;
      xx1=linspace(xk(1)-hk,xk(1)+hk,N);
      xx2=linspace(xk(2)-hk,xk(2)+hk,N);
      [X1,X2]=meshgrid(xx1,xx2);
      for i=1:N
          for j=1:N
              temp=[X1(i,j);X2(i,j)];
              if norm(temp-xk,2)<=hk;
                 s(:,k)=temp;
                 k=k+1;
              end             
          end
      end
      k=1;
      for i=1:length(Xg)
          temp=[Xg(i);Yg(i)];
          if norm(temp-xk,2)<=1.414*hk;
              si(k,:)=temp.';
              f(k)=Zg(i);
              k=k+1; 
          end              
      end
      
      for i=1:N*N 
          ri(i,:)=[X1(i) X2(i)];
      end
%       si
%       size(Xg)
%       pause
      
      if k>9
         [q, coefficients] = mq_interpolation(si,f, s',100 );
      else
         [q,coefficients] = mq_interpolation([Xg Yg],Zg,s',1000);
      end
% 	  S = reshape(fi,N,N);
% 	  figure(2)
% 	  mesh(xx1,xx2,S), hold on, %plot3(si(:,1),si(:,2),f,'o'), hold off 
%       pause
      
      
    % build up trust region model using function values    
    %[q, coefficients] = mq_interpolation([Xg Yg], Zg, s',100);
    
     % approximately solve the trust region model   
    [Zmin,I] = min(q) ;
    % obtain the desire set point
    xs=s(:,I)
    %pause
    flag=0;
   else
     xs=xsucc(:,end);
     flag=1;
   end    

    
elseif icon==0  
    xk=[x1;x2];
    if t>0 & flag==0  
       % compute the performance ratio
       rk=(Zreal-(5*xk(1)^2+xk(2)^2+4*xk(1)*xk(2)-14*xk(1)-6*xk(2)+20))/(Zreal-Zmin);
       %pause
       if rk<0.25
           hk=hk/2; %norm(sk,2)/4;
       elseif  rk>0.75 & norm(sk,2)==hk
           hk=2*hk;        
       else
           hk=hk;
       end        
       % check if this is a successful step
       if rk>0.1
           flag=1;  % successful
           xsucc(:,end+1)=xk;
       else  
           flag=0;  % not successful, need to go back
       end
    end
    
   if t==0 | flag==1       
      % perform function measurment
      Zreal=5*xk(1)^2+xk(2)^2+4*xk(1)*xk(2)-14*xk(1)-6*xk(2)+20;         
      % perform gradient measurement
      grad=[10*xk(1)+4*xk(2)-14;2*xk(2)+4*xk(1)-6];
      % perform Hessian measurement
      Gk=[10,4;4,2];    
      % obtain the data site within the trust region
      k=1;
      xx1=linspace(xk(1)-hk,xk(1)+hk,N);
      xx2=linspace(xk(2)-hk,xk(2)+hk,N);
      [X1,X2]=meshgrid(xx1,xx2);
      for i=1:N
          for j=1:N
              temp=[X1(i,j);X2(i,j)];
              if norm(temp-xk,2)<=hk;
                 %s(:,k)=temp-xk;
                 s(:,k)=temp;
                 k=k+1;
              end             
          end
      end
      
      
      
%      [Nrow,Ncol]=size(s);
%      % build up trust region model
%      for i=1:Ncol        
%           q(i)=Zreal+grad.'*s(:,i)+0.5*(s(:,i).')*Gk*s(:,i);
%      end
     
     % build up trust region model using function values    
 
    for i=1:N*N 
        ri(i,:)=[X1(i) X2(i)];
    end
    [q, coefficients] = mq_interpolation([Xg Yg], Zg, s',100 );
    
     % approximately solve the trust region model   
    [Zmin,I] = min(q) ;
    xs=ri(I,:)';
    % obtain the desire set point
    xs=s(:,I);
      
    % sk=s(:,I);
    % obtain the desire set point
    % xs=xk+sk;   
 
    
    
    
    flag=0;
   else
     xs=xsucc(:,end);
     flag=1;
   end
 else
   grad=[2*(x1-2);2*(x2-3)];
   alpha1=0.3;
 end

% record the set point data set
xsr(:,end+1)=xs;
tsr(:,end+1)=t;
tstart=t;
end
 
hk

% coordinate transformation
z1=x1;
z2=-x1+x2;

% generate the desired set point
zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);
 
% generate a periodic refernce trajectory
a2=zs(1);
w1=2*pi/ts;
a1=zs(2)/w1;

zs1=a1*sin(w1*t)+a2;
zs2=a1*w1*cos(w1*t);
zs3=-a1*w1*w1*sin(w1*t);

% error systems
e=k1*(z1-zs1)+(z2-zs2);
xi=k1*(z2-zs2)-zs3;

u=-xi+(-x1+x2)-x1*x2-k*e;

% Norminal Controller
% step length is 0.0012, CovnT=0.5,  Ts=5
% k1=3; k=3;

% Stabilizing Term
% For smooth version of the nonlinear damping term
% step length is 0.0012, CovnT=0.5,  Ts=5
% k1=3; k=3;
% us=-5*e/(abs(e)+0.3); 

% Stabilizing term for unbounded disturbance
% k1=3, k-1.5, eta=2; 
% step length is 0.001, CovnT=1,  DeltaT=3, disturbance is
% 1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2))
% eta=1;
% us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;


%us=-3*e/(abs(e)+0.05);
%us=-3*sign(e);%
%eta=2;
%us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;

%u=u+us;

% Plant dynamics
xprime(1)=-x1+x2;
xprime(2)=x1*x2+u;
% with bounded input disturbance 
%xprime(2)=x1*x2+(u+5*rand(1)); 
% with unbounded input disturbance
%xprime(2) = x1*x2+(u+1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2));

xprime=xprime.';


tsave = [tsave;t];
usave = [usave;u];